{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:13:46 $                                        =}
{========================================================================}
unit fmAdd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMMixer, StdCtrls, MMSlider, MMMixCtl, MMDesign, ExtCtrls, MMHook;

type
  TAddPropsForm = class(TForm)
    BassControl: TMMMixerControl;
    TrebleControl: TMMMixerControl;
    MMDesigner1: TMMDesigner;
    AudioLine1: TMMAudioLine;
    CurrControl: TMMMixerControl;
    GroupBox1: TGroupBox;
    MMMixerSlider1: TMMMixerSlider;
    CloseBtn: TButton;
    ControlsBox: TGroupBox;
    ControlsLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    BassLabel1: TLabel;
    BassLabel2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    MMMixerSlider2: TMMMixerSlider;
    TrebleLabel1: TLabel;
    TrebleLabel2: TLabel;
    Image1: TImage;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    FTemp : TList;
  public
    procedure ShowProps(LineId: TMMLineId);
    function  HasProps(LineId: TMMLineId): Boolean;
  end;

var
  AddPropsForm: TAddPropsForm;

implementation

uses fmMain;

{$R *.DFM}

{-- TAddPropsForm --------------------------------------------------------}
procedure   TAddPropsForm.ShowProps(LineId: TMMLineId);
begin
   AudioLine1.LineId := LineId;
   ShowModal;
end;

{-- TAddPropsForm --------------------------------------------------------}
procedure TAddPropsForm.FormShow(Sender: TObject);
var
   i       : Integer;
   Y       : Integer;
   VDelta  : Integer;
   HDelta  : Integer;
   Ctl     : TMMMixerControl;
   Delta   : Integer;
   Start   : Integer;

   procedure   AddControl;
   var
      Chk : TMMMixerCheckBox;
      Sld : TMMMixerSlider;
   begin
      if CurrControl.ControlClass = ccSwitch then
      begin
         Chk := TMMMixerCheckBox.Create(Self);
         FTemp.Add(Chk);
         with Chk do
         begin
            Left  := HDelta;
            Top   := Y;
            Width := ControlsBox.Width - 2*HDelta;
            Ctl   := TMMMixerControl.Create(Self);
            FTemp.Add(Ctl);
            with Ctl do
            begin
               AudioLine := AudioLine1;
               ControlId := CurrControl.ControlId;
            end;
            Control := Ctl;
            Short   := False;
            Visible := True;
            Parent  := ControlsBox;
            Inc(Y,Height+VDelta);
         end;
      end
      else if CurrControl.ControlClass in MixerSliderControlClasses then
      begin
         Sld := TMMMixerSlider.Create(Self);
         FTemp.Add(Sld);
         with Sld do
         begin
            Left    := HDelta;
            Top     := Y;
            Width   := ControlsBox.Width - 2*HDelta;
            Ctl     := TMMMixerControl.Create(Self);
            FTemp.Add(Ctl);
            with Ctl do
            begin
               AudioLine := AudioLine1;
               ControlId := CurrControl.ControlId;
            end;
            Control := Ctl;
            Visible := True;
            Parent  := ControlsBox;
            Inc(Y,Height+VDelta);
         end;
      end;
   end;

begin
   VDelta := Canvas.TextHeight('A');
   HDelta := ControlsLabel.Left;
   Start  := ControlsLabel.Top + ControlsLabel.Height + VDelta;
   Y      := Start;

   for i := 0 to AudioLine1.Controls - 1 do
   begin
      CurrControl.ControlId := AudioLine1.Control[i];
      if ((CurrControl.ControlClass in [ccSwitch]) and (CurrControl.ControlType <> ctMute)) or
         ((CurrControl.ControlClass in MixerSliderControlClasses) and not (CurrControl.ControlType in [ctVolume,ctPan,ctTreble,ctBass])) then
           AddControl;
   end;

   if Y = Start then
   begin
      ControlsBox.Visible := False;
      Delta               := -ControlsBox.Height;
   end
   else
   begin
      ControlsBox.Visible := True;
      Delta               := (Y + VDelta) - ControlsBox.Height;
   end;

   ControlsBox.Height  := ControlsBox.Height + Delta;
   CloseBtn.Top        := CloseBtn.Top + Delta;
   Height              := Height + Delta;
   Caption             := 'Advanced controls for ' + AudioLine1.LineInfo.Name;
   BassLabel1.Enabled  := BassControl.Available;
   BassLabel2.Enabled  := BassControl.Available;
   TrebleLabel1.Enabled:= TrebleControl.Available;
   TrebleLabel2.Enabled:= TrebleControl.Available;
end;

{-- TAddPropsForm --------------------------------------------------------}
procedure TAddPropsForm.FormCreate(Sender: TObject);
begin
   FTemp := TList.Create;

   AudioLine1.Mixer := MainForm.MixerDevice1;
end;

{-- TAddPropsForm --------------------------------------------------------}
procedure TAddPropsForm.FormDestroy(Sender: TObject);
begin
   FTemp.Free;
end;

{-- TAddPropsForm --------------------------------------------------------}
procedure TAddPropsForm.FormHide(Sender: TObject);
var
   i : Integer;
begin
   for i := 0 to FTemp.Count - 1 do
       TComponent(FTemp[i]).Free;
   FTemp.Clear;
end;

{-- TAddPropsForm --------------------------------------------------------}
function TAddPropsForm.HasProps(LineId: TMMLineId): Boolean;
var
   i: Integer;
begin
   AudioLine1.LineId := LineId;
   Result := True;
   if BassControl.Available or TrebleControl.Available then
      Exit;
   for i := 0 to AudioLine1.Controls - 1 do
   begin
      CurrControl.ControlId := AudioLine1.Control[i];
      if ((CurrControl.ControlClass in [ccSwitch]) and (CurrControl.ControlType <> ctMute)) or
         ((CurrControl.ControlClass in MixerSliderControlClasses) and not (CurrControl.ControlType in [ctVolume,ctPan,ctTreble,ctBass])) then
          Exit;
   end;
   Result := False;
end;

end.
